;This is a program is part of the Chapter 14 exercises to demonstrate 
;the basic operation of the TMR0 resource.  The program simply configures 
;the TMR0 interrupt resource and uses the MPLab simulator capabilities to 
;monitor the INTCON and TMR0 registers and uses the timer resource to 
;determine the timer time interval as a function of the vlues stored in the TMR0 register.



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80

;*******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	TMR0_time
	endc

;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	goto interrupt_service
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	BANKSEL	Bank0		;select bank0
	clrf	PORTA		;clear port bus
	clrf	PORTC
	movlw	b'00000111'	;comparator disconnected
	movwf	CMCON		;

	BANKSEL	Bank1		; BANK1
	movlw	b'00001000' ;pre-scale assigned to WDT, no pre-scale on TMR0
;	movlw	b'00000000'	;TMR0 set-up: prescale tmr0, pre-scale 1:2 
;	movlw	b'00000011'	;TMR0 set-up: prescale tmr0, pre-scale 1:16
;	movlw	b'00000111'	;TMR0 set-up: prescale tmr0, pre-scale 1:256  
	movwf	OPTION_REG	;put w-register into option register, this starts TMR0

	movlw	b'00000000'	;all PORTA I/O outputs
	movwf	TRISA		;program PORTA
	movlw	b'00000000'	;all PORTC I/O outputs
	movwf	TRISC		;program PORTC
	movlw	b'00000000'	;all digital
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
		
	movlw	b'00000000'	;globals disabled, TMR0 disabled, clear T0IF
	movwf	INTCON

;end pic initialization

;*****************************************************************************

;main program
	movlw	b'00000000'		;preload TMR0 for a count that will generate an 
	movwf	TMR0			;interrupt of length determined by this value

	bcf		INTCON,T0IF		;clear TMR0 interrupt flag
	bsf		INTCON,T0IE		;enable TMR0
	bsf		INTCON,GIE		;enable global interrupts
	
self
	goto	self			;keep the main program busy doing something while
							;waiting for an interrupt from TRM0

interrupt_service
	bcf		INTCON,T0IE		;disable TMR0 interrupt
	bcf		INTCON,T0IF		;clear TMR0 interrupt flag

	nop						;place holder in the program

	bsf		INTCON,T0IE		;enable TMR0 interrupt
	movlw	b'00000000'		;reset TMR0 for a count that will generate an 
	movwf	TMR0			;interrupt of length determined by this value
	retfie					;return from interrupt this also sets GIE
	
	


	end
